using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class DOD_FRAGMENTDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public DOD_FRAGMENTDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public BO.DOD_FRAGMENT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DOD_FRAGMENT_ID)
		{
			BO.DOD_FRAGMENT objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DOD_FRAGMENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, DOD_FRAGMENT_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<BO.DOD_FRAGMENT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<BO.DOD_FRAGMENT> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DOD_FRAGMENT_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, BO.DOD_FRAGMENT objSave)
		{
			Int32? objReturn = objSave.DOD_FRAGMENT_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DOD_FRAGMENT_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMMENTS, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.DOD_FRAGMENT_LAB_ID, objSave.FRAGMENT_DESCRIPTION, objSave.FRAGMENT_ID_NUMBER, objSave.HEIGHT, objSave.HEIGHT_UNITS, objSave.LENGTH, objSave.LENGTH_UNITS, objSave.MASS, objSave.MASS_UNITS, objSave.RADIOACTIVEINDICATOR, objSave.RADIOACTIVERESULTS, objSave.TISSUE_ASSOCIATED_WITH_FRAGMENT, objSave.TISSUE_SENT_FLAG, DateTime.Now, objSave.UPDATEDBY, objSave.WIDTH, objSave.WIDTH_UNITS);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DOD_FRAGMENT_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DOD_FRAGMENT_delete(CURRENT_USER, CURRENT_REGISTRY_ID, DOD_FRAGMENT_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
